/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonElementVisitor;
import com.google.gson.JsonEscapingVisitor;
import com.google.gson.JsonFormatter;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonTreeNavigator;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

final class JsonPrintFormatter
implements JsonFormatter {
    private final int printMargin;
    private final int indentationSize;
    private final int rightMargin;
    public static final int DEFAULT_PRINT_MARGIN = 80;
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final int DEFAULT_RIGHT_MARGIN = 4;

    public JsonPrintFormatter() {
        this(80, 2, 4);
    }

    public JsonPrintFormatter(int printMargin, int indentationSize, int rightMargin) {
        this.printMargin = printMargin;
        this.indentationSize = indentationSize;
        this.rightMargin = rightMargin;
    }

    public void format(JsonElement root, PrintWriter writer, boolean serializeNulls) {
        if (root == null) {
            return;
        }
        JsonWriter jsonWriter = new JsonWriter(writer);
        JsonEscapingVisitor visitor = new JsonEscapingVisitor(new PrintFormattingVisitor(jsonWriter, serializeNulls));
        JsonTreeNavigator navigator = new JsonTreeNavigator(visitor, serializeNulls);
        navigator.navigate(root);
        jsonWriter.finishLine();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrintFormattingVisitor
    implements JsonElementVisitor {
        private final Map<Integer, Boolean> firstArrayElement;
        private final Map<Integer, Boolean> firstObjectMember;
        private final JsonWriter writer;
        private final boolean serializeNulls;
        private int level = 0;

        PrintFormattingVisitor(JsonWriter writer, boolean serializeNulls) {
            this.writer = writer;
            this.serializeNulls = serializeNulls;
            this.firstArrayElement = new HashMap<Integer, Boolean>();
            this.firstObjectMember = new HashMap<Integer, Boolean>();
        }

        private void addCommaCheckingFirst(Map<Integer, Boolean> first) {
            if (first.get(this.level) != Boolean.FALSE) {
                first.put(this.level, false);
            } else {
                this.writer.elementSeparator();
            }
        }

        @Override
        public void startArray(JsonArray array) {
            this.firstArrayElement.put(++this.level, true);
            this.writer.beginArray();
        }

        @Override
        public void visitArrayMember(JsonArray parent, JsonPrimitive member, boolean isFirst) {
            this.addCommaCheckingFirst(this.firstArrayElement);
            this.writer.value(member.toString());
        }

        @Override
        public void visitArrayMember(JsonArray parent, JsonArray member, boolean first) {
            this.addCommaCheckingFirst(this.firstArrayElement);
        }

        @Override
        public void visitArrayMember(JsonArray parent, JsonObject member, boolean first) {
            this.addCommaCheckingFirst(this.firstArrayElement);
        }

        @Override
        public void visitNullArrayMember(JsonArray parent, boolean isFirst) {
            this.addCommaCheckingFirst(this.firstArrayElement);
        }

        @Override
        public void endArray(JsonArray array) {
            --this.level;
            this.writer.endArray();
        }

        @Override
        public void startObject(JsonObject object) {
            this.firstObjectMember.put(this.level, true);
            this.writer.beginObject();
        }

        @Override
        public void visitObjectMember(JsonObject parent, String memberName, JsonPrimitive member, boolean isFirst) {
            this.addCommaCheckingFirst(this.firstObjectMember);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
            this.writer.value(member.toString());
        }

        @Override
        public void visitObjectMember(JsonObject parent, String memberName, JsonArray member, boolean isFirst) {
            this.addCommaCheckingFirst(this.firstObjectMember);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
        }

        @Override
        public void visitObjectMember(JsonObject parent, String memberName, JsonObject member, boolean isFirst) {
            this.addCommaCheckingFirst(this.firstObjectMember);
            this.writer.key(memberName);
            this.writer.fieldSeparator();
        }

        @Override
        public void visitNullObjectMember(JsonObject parent, String memberName, boolean isFirst) {
            if (this.serializeNulls) {
                this.visitObjectMember(parent, memberName, (JsonObject)null, isFirst);
            }
        }

        @Override
        public void endObject(JsonObject object) {
            this.writer.endObject();
        }

        @Override
        public void visitPrimitive(JsonPrimitive primitive) {
            this.writer.value(primitive.toString());
        }

        @Override
        public void visitNull() {
            this.writer.value("null");
        }
    }

    private class JsonWriter {
        private final PrintWriter writer;
        private StringBuilder line;
        private int level;

        JsonWriter(PrintWriter writer) {
            this.writer = writer;
            this.level = 0;
            this.line = new StringBuilder();
        }

        void key(String key) {
            this.getLine().append('\"');
            this.getLine().append(key);
            this.getLine().append('\"');
        }

        void value(String value) {
            this.getLine().append(value);
        }

        void fieldSeparator() {
            this.getLine().append(':');
            this.breakLineIfNeeded();
        }

        void elementSeparator() {
            this.getLine().append(',');
            this.breakLineIfNeeded();
        }

        void beginObject() {
            ++this.level;
            this.breakLineIfNeeded();
            this.getLine().append('{');
        }

        void endObject() {
            this.getLine().append('}');
            --this.level;
        }

        void beginArray() {
            ++this.level;
            this.breakLineIfNeeded();
            this.getLine().append('[');
        }

        void endArray() {
            this.getLine().append(']');
            --this.level;
        }

        private void breakLineIfNeeded() {
            if (this.getLine().length() > JsonPrintFormatter.this.printMargin - JsonPrintFormatter.this.rightMargin) {
                this.finishLine();
            }
        }

        private void finishLine() {
            if (this.line != null) {
                this.writer.append(this.line).append("\n");
            }
            this.line = null;
        }

        private StringBuilder getLine() {
            if (this.line == null) {
                this.createNewLine();
            }
            return this.line;
        }

        private void createNewLine() {
            this.line = new StringBuilder();
            for (int i = 0; i < this.level; ++i) {
                for (int j = 0; j < JsonPrintFormatter.this.indentationSize; ++j) {
                    this.line.append(' ');
                }
            }
        }
    }
}

