/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializationVisitor;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.ObjectConstructor;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeInfo;
import com.google.gson.TypeInfoArray;
import com.google.gson.TypeInfoFactory;
import com.google.gson.TypeUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonArrayDeserializationVisitor<T>
extends JsonDeserializationVisitor<T> {
    private final Class<?> componentType;

    JsonArrayDeserializationVisitor(JsonArray jsonArray, Type arrayType, ObjectNavigatorFactory factory, ObjectConstructor objectConstructor, TypeAdapter typeAdapter, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, JsonDeserializationContext context) {
        super(jsonArray, arrayType, factory, objectConstructor, typeAdapter, deserializers, context);
        this.componentType = TypeUtils.toRawClass(arrayType);
    }

    @Override
    protected T constructTarget() {
        TypeInfo typeInfo = new TypeInfo(this.targetType);
        JsonArray jsonArray = this.json.getAsJsonArray();
        if (typeInfo.isPrimitiveOrStringAndNotAnArray()) {
            if (jsonArray.size() != 1) {
                throw new IllegalArgumentException("Primitives should be an array of length 1, but was: " + jsonArray);
            }
            return this.objectConstructor.construct(typeInfo.getWrappedClass());
        }
        if (typeInfo.isArray()) {
            TypeInfoArray arrayTypeInfo = TypeInfoFactory.getTypeInfoForArray(this.targetType);
            return (T)this.objectConstructor.constructArray(arrayTypeInfo.getSecondLevelType(), jsonArray.size());
        }
        return this.objectConstructor.construct(typeInfo.getRawClass());
    }

    @Override
    public void visitArray(Object array, Type arrayType) {
        JsonArray jsonArray = this.json.getAsJsonArray();
        TypeInfoArray arrayTypeInfo = TypeInfoFactory.getTypeInfoForArray(arrayType);
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object child;
            JsonElement jsonChild = jsonArray.get(i);
            if (jsonChild == null) {
                child = null;
            } else if (jsonChild instanceof JsonObject) {
                child = this.visitChildAsObject(arrayTypeInfo.getComponentRawType(), jsonChild);
            } else if (jsonChild instanceof JsonArray) {
                child = this.visitChildAsArray(arrayTypeInfo.getSecondLevelType(), jsonChild.getAsJsonArray());
            } else if (jsonChild instanceof JsonPrimitive) {
                child = this.visitChildAsPrimitive(arrayTypeInfo.getComponentRawType(), jsonChild.getAsJsonPrimitive());
            } else {
                throw new IllegalStateException();
            }
            Array.set(array, i, child);
        }
    }

    @Override
    public void visitCollection(Collection collection, Type collectionType) {
        Type childType = TypeUtils.getActualTypeForFirstTypeVariable(collectionType);
        for (JsonElement jsonChild : this.json.getAsJsonArray()) {
            if (childType == Object.class) {
                throw new JsonParseException(collection + " must not be a raw collection. Try making it genericized instead.");
            }
            Object child = this.visitChild(childType, jsonChild);
            collection.add(child);
        }
    }

    @Override
    public void visitPrimitiveValue(Object obj) {
        this.target = this.typeAdapter.adaptType(this.json.getAsJsonArray().get(0).getAsObject(), this.componentType);
    }

    @Override
    public void endVisitingObject(Object node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startVisitingObject(Object node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitArrayField(Field f, Type typeOfF, Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitCollectionField(Field f, Type typeOfF, Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitObjectField(Field f, Type typeOfF, Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitPrimitiveField(Field f, Type typeOfF, Object obj) {
        throw new UnsupportedOperationException();
    }
}

