/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.parser;

import java.util.ArrayList;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Binding;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class BindingsParser
extends Parser {
    private static final Log log = Log.getLog((String)BindingsParser.class.getName());

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        parse.setDocumentObject(bindings);
        for (Element bindingElement : XmlUtil.elements((Element)documentElement)) {
            Binding binding = this.instantiateBinding(bindingElement, parse);
            bindings.add(binding);
        }
        return bindings;
    }

    protected Binding instantiateBinding(Element bindingElement, Parse parse) {
        String bindingClassName = XmlUtil.attribute((Element)bindingElement, (String)"binding", (Parse)parse);
        log.trace("adding bpmn binding " + bindingClassName);
        if (bindingClassName != null) {
            try {
                Class bindingClass = ReflectUtil.classForName((String)bindingClassName);
                return (Binding)bindingClass.newInstance();
            }
            catch (Exception e) {
                parse.addProblem("couldn't instantiate activity binding " + bindingClassName, e);
            }
        }
        return null;
    }
}

