/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.model.Activity;
import org.jbpm.bpmn.flownodes.BpmnExternalActivity;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.CompositeElementImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ScopeElementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubProcessActivity
extends BpmnExternalActivity {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog((String)SubProcessActivity.class.getName());

    @Override
    public void execute(ExecutionImpl execution) {
        List<Activity> startActivities = this.findStartActivities(execution);
        if (!startActivities.isEmpty()) {
            ExecutionImpl parent = execution.createScope((ScopeElementImpl)execution.getActivity());
            for (Activity startActivity : startActivities) {
                parent.setState("inactive-concurrent-root");
                ExecutionImpl concurrentExecution = parent.createExecution();
                concurrentExecution.setState("active-concurrent");
                concurrentExecution.execute(startActivity);
            }
        } else {
            throw new JbpmException("Could not find start activity for the sub-process " + execution.getActivityName());
        }
    }

    protected List<Activity> findStartActivities(ExecutionImpl execution) {
        ArrayList<Activity> startActivities = new ArrayList<Activity>();
        for (Activity nestedActivity : execution.getActivity().getActivities()) {
            if (nestedActivity.getIncomingTransitions() != null && !nestedActivity.getIncomingTransitions().isEmpty()) continue;
            startActivities.add(nestedActivity);
        }
        return startActivities;
    }

    public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        ExecutionImpl scopedExecution = (ExecutionImpl)execution.getParent();
        if (scopedExecution.getExecutions() != null && scopedExecution.getExecutions().size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scoped execution " + scopedExecution.getId() + " has active child executions." + "Ending current execution, but scoped execution is not yet continued");
            }
            execution.end();
        } else {
            ExecutionImpl parent = scopedExecution.destroyScope((CompositeElementImpl)activity);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scoped execution " + scopedExecution.getId() + " has no active child executions." + "Destroying scope and proceeding from parent execution " + parent.getId());
            }
            this.proceed(parent, this.findOutgoingSequenceFlow(parent, true));
        }
    }
}

