/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import junit.framework.TestCase;
import org.jbpm.internal.log.Log;
import org.jbpm.test.JmsTopicListener;

public class JmsNonXATopicListener
implements JmsTopicListener {
    private static Log log = Log.getLog(JmsNonXATopicListener.class.getName());
    String topicJndiName = null;
    String connectionFactoryJndiName = null;
    boolean transacted;
    int acknowledgeMode;
    TopicConnectionFactory topicConnectionFactory = null;
    Topic topic = null;
    TopicConnection topicConnection = null;
    TopicSession topicSession = null;
    TopicSubscriber topicSubscriber = null;
    List<Message> messages = null;

    JmsNonXATopicListener(String connectionFactoryJndiName, String topicJndiName, boolean transacted, int acknowledgeMode) {
        this.connectionFactoryJndiName = connectionFactoryJndiName;
        this.topicJndiName = topicJndiName;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.start();
    }

    void start() {
        try {
            this.messages = Collections.synchronizedList(new ArrayList());
            InitialContext context = new InitialContext();
            this.topicConnectionFactory = (TopicConnectionFactory)context.lookup(this.connectionFactoryJndiName);
            this.topic = (Topic)context.lookup(this.topicJndiName);
            this.topicConnection = this.topicConnectionFactory.createTopicConnection();
            this.topicSession = this.topicConnection.createTopicSession(this.transacted, this.acknowledgeMode);
            this.topicSubscriber = this.topicSession.createSubscriber(this.topic);
            this.topicSubscriber.setMessageListener((MessageListener)new Listener());
            this.topicConnection.start();
        }
        catch (Exception e) {
            this.stop();
            throw new RuntimeException("couldn't subscribe message listener to topic '" + this.topicJndiName + "': " + e.getMessage(), e);
        }
    }

    public void stop() {
        if (this.transacted && this.topicSession != null) {
            try {
                this.topicSession.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.topicConnection != null) {
            try {
                this.topicConnection.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.topicSubscriber != null) {
            try {
                this.topicSubscriber.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.topicSubscriber = null;
        }
        if (this.topicSession != null) {
            try {
                this.topicSession.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.topicSession = null;
        }
        if (this.topicConnection != null) {
            try {
                this.topicConnection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.topicConnection = null;
        }
    }

    public Message getNextMessage(long timeout) {
        long start = System.currentTimeMillis();
        while (this.messages.isEmpty()) {
            if (System.currentTimeMillis() - start > timeout) {
                TestCase.fail((String)("no message for topic " + this.topicJndiName));
            }
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                log.info("waiting for next message got interrupted");
                continue;
            }
            break;
        }
        return this.messages.remove(0);
    }

    private class Listener
    implements MessageListener {
        private Listener() {
        }

        public void onMessage(Message message) {
            JmsNonXATopicListener.this.messages.add(message);
        }
    }
}

