/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.xml;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import org.jbpm.pvm.internal.stream.FileStreamInput;
import org.jbpm.pvm.internal.stream.InputStreamInput;
import org.jbpm.pvm.internal.stream.ResourceStreamInput;
import org.jbpm.pvm.internal.stream.StreamInput;
import org.jbpm.pvm.internal.stream.StringStreamInput;
import org.jbpm.pvm.internal.stream.UrlStreamInput;
import org.jbpm.pvm.internal.xml.Parser;
import org.jbpm.pvm.internal.xml.ProblemImpl;
import org.jbpm.pvm.internal.xml.ProblemList;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parse
extends ProblemList
implements ErrorHandler {
    private static final long serialVersionUID = 1L;
    public static final String CONTEXT_KEY_DEPLOYMENT = "deployment";
    public static final String CONTEXT_KEY_PROCESS_LANGUAGE_ID = "proclangid";
    public static final String CONTEXT_KEY_BINDINGS = "bindings";
    public static final String CONTEXT_KEY_MIGRATIONS = "migrations";
    protected Parser parser;
    protected StreamInput streamInput;
    protected InputStream inputStream;
    protected InputSource inputSource;
    protected DocumentBuilder documentBuilder = null;
    protected Document document = null;
    protected Map<String, Object> contextMap;
    protected Stack<Object> contextStack;
    protected Object documentObject;

    protected Parse(Parser parser) {
        this.parser = parser;
    }

    public Parse setInputStream(InputStream inputStream) {
        this.streamInput = new InputStreamInput(inputStream);
        return this;
    }

    public Parse setUrl(URL url) {
        this.streamInput = new UrlStreamInput(url);
        return this;
    }

    public Parse setFile(File file) {
        this.streamInput = new FileStreamInput(file);
        return this;
    }

    public Parse setResource(String resource) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.streamInput = new ResourceStreamInput(resource, classLoader);
        return this;
    }

    public Parse setString(String xmlString) {
        this.streamInput = new StringStreamInput(xmlString);
        return this;
    }

    public Parse setStreamSource(StreamInput streamInput) {
        this.streamInput = streamInput;
        return this;
    }

    public Parse setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
        return this;
    }

    public Parse setDocument(Document document) {
        this.document = document;
        return this;
    }

    public Parse setDocumentObject(Object object) {
        this.documentObject = object;
        return this;
    }

    protected InputSource getInputSource() {
        if (this.inputSource != null) {
            return this.inputSource;
        }
        if (this.streamInput != null) {
            this.inputStream = this.streamInput.openStream();
            return new InputSource(this.inputStream);
        }
        this.addProblem("no source specified to parse");
        return null;
    }

    public Parse execute() {
        this.parser.execute(this);
        return this;
    }

    @Override
    public void error(SAXParseException e) {
        this.addXmlValidationProblem(e, "xml validation error");
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.addXmlValidationProblem(e, "xml validation error");
    }

    @Override
    public void warning(SAXParseException e) {
        this.addXmlValidationProblem(e, "xml validation warning");
    }

    protected void addXmlValidationProblem(SAXParseException e, String type) {
        ProblemImpl problem = new ProblemImpl(e.getMessage(), e, type);
        problem.setLine(e.getLineNumber());
        problem.setColumn(e.getColumnNumber());
        this.addProblem(problem);
    }

    public Parse checkErrors(String description) {
        if (this.hasErrors()) {
            throw this.getJbpmException(description);
        }
        return this;
    }

    public Parse contextMapPut(String key, Object value) {
        if (this.contextMap == null) {
            this.contextMap = new HashMap<String, Object>();
        }
        this.contextMap.put(key, value);
        return this;
    }

    public Object contextMapGet(String key) {
        if (this.contextMap != null) {
            return this.contextMap.get(key);
        }
        return null;
    }

    public Parse contextMapRemove(String key) {
        if (this.contextMap != null) {
            this.contextMap.remove(key);
        }
        return this;
    }

    public Parse propagateContexMap(Parse parse) {
        if (parse.contextMap == null) {
            parse.contextMap = new HashMap<String, Object>();
        }
        if (this.contextMap != null) {
            parse.contextMap.putAll(this.contextMap);
        }
        this.contextMap = parse.contextMap;
        return this;
    }

    public Parse contextStackPush(Object object) {
        if (this.contextStack == null) {
            this.contextStack = new Stack();
        }
        this.contextStack.push(object);
        return this;
    }

    public Object contextStackPop() {
        if (this.contextStack != null) {
            return this.contextStack.pop();
        }
        return null;
    }

    public Object contextStackPeek() {
        if (this.contextStack != null) {
            return this.contextStack.peek();
        }
        return null;
    }

    public <T> T contextStackFind(Class<T> clazz) {
        if (this.contextStack != null && !this.contextStack.isEmpty()) {
            ListIterator listIter = this.contextStack.listIterator(this.contextStack.size());
            while (listIter.hasPrevious()) {
                Object object = listIter.previous();
                if (!clazz.isInstance(object)) continue;
                return clazz.cast(object);
            }
        }
        return null;
    }

    public Object getDocumentObject() {
        return this.documentObject;
    }

    public Document getDocument() {
        return this.document;
    }
}

