/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.io.ObjectStreamException;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.query.Page;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery
implements Command<Object> {
    private static final long serialVersionUID = 1L;
    protected CommandService commandService;
    protected String orderByClause;
    protected Page page;
    protected boolean isWhereAdded;
    protected boolean count;
    protected boolean uniqueResult;

    protected abstract void applyParameters(Query var1);

    public abstract String hql();

    public List<?> untypedList() {
        if (this.commandService != null) {
            return (List)this.commandService.execute(this);
        }
        Session session = EnvironmentImpl.getFromCurrent(Session.class);
        return (List)this.execute(session);
    }

    protected Object untypedUniqueResult() {
        this.uniqueResult = true;
        if (this.commandService != null) {
            return this.commandService.execute(this);
        }
        Session session = EnvironmentImpl.getFromCurrent(Session.class);
        return this.execute(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Environment environment) throws Exception {
        Session session = environment.get(Session.class);
        try {
            Object object = this.execute(session);
            return object;
        }
        finally {
            this.resetQuery();
        }
    }

    public Object execute(Session session) {
        Query query = session.createQuery(this.hql());
        this.applyParameters(query);
        this.applyPage(query);
        return this.uniqueResult ? query.uniqueResult() : query.list();
    }

    public long count() {
        this.count = true;
        if (this.page != null) {
            throw new JbpmException("page(firstResult, maxResult) and count() cannot be used together");
        }
        return (Long)this.untypedUniqueResult();
    }

    private void resetQuery() {
        this.isWhereAdded = false;
        this.count = false;
        this.uniqueResult = false;
    }

    protected void appendWhereClause(String whereClause, StringBuilder hql) {
        if (this.isWhereAdded) {
            hql.append("  and ");
        } else {
            this.isWhereAdded = true;
            hql.append("where ");
        }
        hql.append(whereClause);
    }

    protected void appendOrderByClause(StringBuilder hql) {
        if (this.orderByClause != null) {
            hql.append("order by ");
            hql.append(this.orderByClause);
        }
    }

    protected void applyPage(Query query) {
        if (this.page != null) {
            query.setFirstResult(this.page.firstResult);
            query.setMaxResults(this.page.maxResults);
        }
    }

    protected void addOrderByClause(String clause) {
        this.orderByClause = this.orderByClause == null ? clause : this.orderByClause + ", " + clause;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.commandService = null;
        return this;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }
}

