/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.el;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public final class JstlFunction {
    private JstlFunction() {
    }

    public static boolean contains(String name, String searchString) {
        if (name == null) {
            name = "";
        }
        if (searchString == null) {
            searchString = "";
        }
        return name.contains(searchString);
    }

    public static boolean containsIgnoreCase(String name, String searchString) {
        if (name == null) {
            name = "";
        }
        if (searchString == null) {
            searchString = "";
        }
        return name.toLowerCase().contains(searchString.toLowerCase());
    }

    public static boolean endsWith(String name, String searchString) {
        if (name == null) {
            name = "";
        }
        if (searchString == null) {
            searchString = "";
        }
        return name.endsWith(searchString);
    }

    public static String escapeXml(String value) {
        if (value == null || value.length() == 0) {
            value = "";
        }
        StringBuilder b = new StringBuilder(value.length());
        char[] lookahead = new char[]{'a', 'm', 'p', ';'};
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\'') {
                b.append("&#039;");
                continue;
            }
            if (c == '\"') {
                b.append("&#034;");
                continue;
            }
            if (c == '&') {
                boolean matched = true;
                int jlen = lookahead.length;
                for (int j = 0; j < jlen; ++j) {
                    if (lookahead[j] == value.charAt(i + (j + 1))) continue;
                    matched = false;
                    break;
                }
                if (matched) {
                    i += 4;
                }
                b.append("&amp;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static int indexOf(String name, String searchString) {
        if (name == null) {
            name = "";
        }
        if (searchString == null) {
            searchString = "";
        }
        return name.indexOf(searchString);
    }

    public static String join(String[] a, String delim) {
        if (a == null || a.length == 0) {
            return "";
        }
        boolean skipDelim = false;
        if (delim == null || delim.length() == 0) {
            skipDelim = true;
        }
        StringBuilder sb = new StringBuilder();
        int len = a.length;
        int delimCount = len - 1;
        for (int i = 0; i < len; ++i) {
            sb.append(a[i]);
            if (skipDelim || i >= delimCount) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator i = (Iterator)obj;
            int count = 0;
            while (i.hasNext()) {
                i.next();
                ++count;
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration e = (Enumeration)obj;
            int count = 0;
            while (e.hasMoreElements()) {
                e.nextElement();
                ++count;
            }
            return count;
        }
        throw new IllegalArgumentException("Object type not supported: " + obj.getClass().getName());
    }

    public static String replace(String value, String before, String after) {
        if (value == null) {
            value = "";
        }
        if (before == null) {
            before = "";
        }
        if (before.length() == 0) {
            return value;
        }
        if (value.length() == 0) {
            return "";
        }
        if (after == null) {
            after = "";
        }
        return value.replaceAll(before, after);
    }

    public static String[] split(String value, String d) {
        if (value == null) {
            value = "";
        }
        if (value.length() == 0) {
            return new String[]{""};
        }
        if (d == null) {
            d = "";
        }
        if (d.length() == 0) {
            return new String[]{value};
        }
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, d);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static boolean startsWith(String value, String p) {
        if (value == null) {
            value = "";
        }
        if (p == null) {
            p = "";
        }
        return value.startsWith(p);
    }

    public static String substring(String v, int s, int e) {
        if (v == null) {
            v = "";
        }
        if (s >= v.length()) {
            return "";
        }
        if (s < 0) {
            s = 0;
        }
        if (e < 0 || e >= v.length()) {
            e = v.length();
        }
        if (e < s) {
            return "";
        }
        return v.substring(s, e);
    }

    public static String substringAfter(String v, String p) {
        int i;
        if (v == null) {
            v = "";
        }
        if (v.length() == 0) {
            return "";
        }
        if (p == null) {
            p = "";
        }
        if ((i = v.indexOf(p)) == -1) {
            return "";
        }
        return v.substring(i + p.length());
    }

    public static String substringBefore(String v, String s) {
        int i;
        if (v == null) {
            v = "";
        }
        if (v.length() == 0) {
            return "";
        }
        if (s == null) {
            s = "";
        }
        if ((i = v.indexOf(s)) == -1) {
            return "";
        }
        return v.substring(0, i);
    }

    public static String toLowerCase(String v) {
        if (v == null || v.length() == 0) {
            return "";
        }
        return v.toLowerCase();
    }

    public static String toUpperCase(String v) {
        if (v == null || v.length() == 0) {
            return "";
        }
        return v.toUpperCase();
    }

    public static String trim(String v) {
        if (v == null || v.length() == 0) {
            return "";
        }
        return v.trim();
    }
}

