/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.el;

import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.el.FactoryFinder;
import org.jbpm.pvm.internal.el.JbpmConstantsElResolver;
import org.jbpm.pvm.internal.el.JbpmElContext;
import org.jbpm.pvm.internal.el.JbpmElFactory;
import org.jbpm.pvm.internal.el.JbpmEnvironmentElResolver;
import org.jbpm.pvm.internal.el.JbpmFunctionMapper;
import org.jbpm.pvm.internal.el.JbpmVariableElResolver;
import org.jbpm.pvm.internal.el.JstlFunction;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;

public class JbpmElFactoryImpl
extends JbpmElFactory {
    private static Log log = Log.getLog(JbpmElFactoryImpl.class.getName());
    Class<?> functionClass = JstlFunction.class;

    public ELContext createElContext() {
        return this.createCompositeResolver(null);
    }

    public ELContext createElContext(ScopeInstanceImpl scopeInstance) {
        return this.createCompositeResolver(scopeInstance);
    }

    protected ELContext createCompositeResolver(ScopeInstanceImpl scopeInstance) {
        EnvironmentImpl environment;
        CompositeELResolver compositeELResolver = new CompositeELResolver();
        if (scopeInstance != null) {
            compositeELResolver.add((ELResolver)new JbpmConstantsElResolver(scopeInstance));
            compositeELResolver.add((ELResolver)new JbpmVariableElResolver(scopeInstance));
        }
        if ((environment = EnvironmentImpl.getCurrent()) != null) {
            compositeELResolver.add((ELResolver)new JbpmEnvironmentElResolver(environment));
        }
        this.addCdiResolver(compositeELResolver);
        this.addBasicResolvers(compositeELResolver);
        FunctionMapper functionMapper = this.createFunctionMapper();
        return this.createElContext(compositeELResolver, functionMapper);
    }

    protected void addCdiResolver(CompositeELResolver compositeELResolver) {
        BeanManager beanManager = this.getBeanManager();
        if (beanManager != null) {
            ELResolver cdiResolver = beanManager.getELResolver();
            if (cdiResolver != null) {
                compositeELResolver.add(cdiResolver);
                log.debug("added cdi el resolver");
            }
        } else {
            log.debug("no cdi bean manager available in jndi");
        }
    }

    protected BeanManager getBeanManager() {
        try {
            InitialContext initialContext = new InitialContext();
            return (BeanManager)initialContext.lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            return null;
        }
    }

    public ExpressionFactory createExpressionFactory() {
        ExpressionFactory expressionFactory;
        try {
            expressionFactory = ExpressionFactory.newInstance();
        }
        catch (NoSuchMethodError e) {
            expressionFactory = (ExpressionFactory)FactoryFinder.find(ExpressionFactory.class.getName(), "de.odysseus.el.ExpressionFactoryImpl", null, "el.properties");
        }
        BeanManager beanManager = this.getBeanManager();
        if (beanManager != null) {
            expressionFactory = beanManager.wrapExpressionFactory(expressionFactory);
        }
        return expressionFactory;
    }

    protected void addBasicResolvers(CompositeELResolver compositeELResolver) {
        compositeELResolver.add((ELResolver)new ResourceBundleELResolver());
        compositeELResolver.add((ELResolver)new MapELResolver());
        compositeELResolver.add((ELResolver)new ListELResolver());
        compositeELResolver.add((ELResolver)new ArrayELResolver());
        compositeELResolver.add((ELResolver)new BeanELResolver());
    }

    protected FunctionMapper createFunctionMapper() {
        return new JbpmFunctionMapper(this.functionClass);
    }

    protected JbpmElContext createElContext(CompositeELResolver compositeELResolver, FunctionMapper functionMapper) {
        return new JbpmElContext((ELResolver)compositeELResolver, functionMapper);
    }
}

