/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.history.HistoryComment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetTaskCommentsCmd
extends AbstractCommand<List<HistoryComment>> {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskCommentsCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<HistoryComment> execute(Environment environment) throws Exception {
        DbSession dbSession = environment.get(DbSession.class);
        List<HistoryComment> comments = dbSession.findCommentsByTaskId(this.taskId);
        this.forceInitializationAndClean(comments);
        return comments;
    }

    protected void forceInitializationAndClean(List<? extends HistoryComment> comments) {
        if (comments != null) {
            comments.size();
            ArrayList<? extends HistoryComment> copy = new ArrayList<HistoryComment>(comments);
            for (int i = 0; i < copy.size(); ++i) {
                HistoryComment comment = (HistoryComment)copy.get(i);
                if (comment == null) {
                    comments.remove(i);
                    continue;
                }
                this.forceInitializationAndClean(comment.getReplies());
            }
        }
    }
}

