/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.flownodes;

import org.jbpm.bpmn.flownodes.BpmnBinding;
import org.jbpm.bpmn.flownodes.IntermediateCatchTimerEvent;
import org.jbpm.bpmn.parser.BpmnParser;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.EventImpl;
import org.jbpm.pvm.internal.model.TimerDefinitionImpl;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class IntermediateCatchEventBinding
extends BpmnBinding {
    public IntermediateCatchEventBinding() {
        super("intermediateCatchEvent");
    }

    public Object parse(Element element, Parse parse, BpmnParser bpmnParser) {
        String id = XmlUtil.attribute(element, "id");
        Element eventDefinition = XmlUtil.element(element);
        if ("timerEventDefinition".equals(eventDefinition.getNodeName())) {
            return this.createIntermediateTimerCatchEvent(id, eventDefinition, bpmnParser, parse);
        }
        parse.addProblem("Invalid eventDefinition type : " + eventDefinition.getNodeName());
        return null;
    }

    protected IntermediateCatchTimerEvent createIntermediateTimerCatchEvent(String catchEventId, Element eventDefinitionElement, BpmnParser parser, Parse parse) {
        IntermediateCatchTimerEvent intermediateCatchTimerEvent = new IntermediateCatchTimerEvent();
        TimerDefinitionImpl timerDefinition = parser.parseTimerEventDefinition(eventDefinitionElement, parse, catchEventId);
        ActivityImpl activity = parse.contextStackFind(ActivityImpl.class);
        activity.addTimerDefinition(timerDefinition);
        String eventName = "INTERMEDIATE_TIMER_" + catchEventId;
        timerDefinition.setEventName(eventName);
        EventImpl timerEvent = activity.createEvent(eventName);
        timerEvent.createEventListenerReference(intermediateCatchTimerEvent);
        return intermediateCatchTimerEvent;
    }
}

