/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.drools.base.ValueType;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.Evaluator;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ReadAccessor;
import org.drools.spi.Restriction;
import org.drools.time.Interval;

public class VariableRestriction
implements AcceptsReadAccessor,
Restriction {
    private static final long serialVersionUID = 400L;
    private Declaration declaration;
    private Declaration[] requiredDeclarations;
    private Evaluator evaluator;
    private InternalReadAccessor readAccessor;

    public VariableRestriction() {
    }

    public VariableRestriction(InternalReadAccessor fieldExtractor, Declaration declaration, Evaluator evaluator) {
        this.declaration = declaration;
        this.requiredDeclarations = new Declaration[]{declaration};
        this.evaluator = evaluator;
        this.readAccessor = fieldExtractor;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.declaration);
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.evaluator);
        out.writeObject(this.readAccessor);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.declaration = (Declaration)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.evaluator = (Evaluator)in.readObject();
        this.readAccessor = (InternalReadAccessor)in.readObject();
    }

    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.readAccessor = readAccessor;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        if (this.declaration.equals(oldDecl)) {
            this.declaration = newDecl;
            this.requiredDeclarations[0] = newDecl;
        }
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean isAllowed(InternalReadAccessor extractor, InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        return this.evaluator.evaluate(workingMemory, this.readAccessor, this.evaluator.prepareLeftObject(handle), this.declaration.getExtractor(), this.evaluator.prepareRightObject(handle));
    }

    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        return this.evaluator.evaluateCachedLeft(((VariableContextEntry)context).workingMemory, (VariableContextEntry)context, this.evaluator.prepareRightObject(handle));
    }

    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        return this.evaluator.evaluateCachedRight(((VariableContextEntry)context).workingMemory, (VariableContextEntry)context, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
    }

    public boolean isTemporal() {
        return this.evaluator.isTemporal();
    }

    public Interval getInterval() {
        return this.evaluator.getInterval();
    }

    public String toString() {
        return "[VariableRestriction declaration=" + this.declaration + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.declaration == null ? 0 : this.declaration.hashCode());
        result = 31 * result + (this.evaluator == null ? 0 : this.evaluator.hashCode());
        result = 31 * result + this.requiredDeclarations[0].hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VariableRestriction other = (VariableRestriction)object;
        return this.declaration.equals(other.declaration) && this.evaluator.equals(other.evaluator) && Arrays.equals(this.requiredDeclarations, other.requiredDeclarations);
    }

    private final VariableContextEntry createContextEntry(Evaluator eval, InternalReadAccessor fieldExtractor) {
        ValueType coerced = eval.getCoercedValueType();
        if (coerced.isBoolean()) {
            return new BooleanVariableContextEntry(fieldExtractor, this.declaration, this.evaluator);
        }
        if (coerced.isFloatNumber()) {
            return new DoubleVariableContextEntry(fieldExtractor, this.declaration, this.evaluator);
        }
        if (coerced.isIntegerNumber() || coerced.isEvent()) {
            return new LongVariableContextEntry(fieldExtractor, this.declaration, this.evaluator);
        }
        if (coerced.isChar()) {
            return new CharVariableContextEntry(fieldExtractor, this.declaration, this.evaluator);
        }
        return new ObjectVariableContextEntry(fieldExtractor, this.declaration, this.evaluator);
    }

    public ContextEntry createContextEntry() {
        return this.createContextEntry(this.evaluator, this.readAccessor);
    }

    public Object clone() {
        return new VariableRestriction(this.readAccessor, (Declaration)this.declaration.clone(), this.evaluator);
    }

    public static class BooleanVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 400L;
        public boolean left;
        public boolean right;

        public BooleanVariableContextEntry() {
        }

        public BooleanVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readBoolean();
            this.right = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeBoolean(this.left);
            out.writeBoolean(this.right);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
            this.left = !this.leftNull ? this.declaration.getExtractor().getBooleanValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration))) : false;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = this.evaluator.prepareLeftObject(handle);
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, this.evaluator.prepareRightObject(handle));
            this.right = !this.rightNull ? this.extractor.getBooleanValue(workingMemory, this.evaluator.prepareRightObject(handle)) : false;
        }
    }

    public static class DoubleVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 400L;
        public double left;
        public double right;

        public DoubleVariableContextEntry() {
        }

        public DoubleVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readDouble();
            this.right = in.readDouble();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeDouble(this.left);
            out.writeDouble(this.right);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
            this.left = !this.leftNull ? this.declaration.getExtractor().getDoubleValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration))) : 0.0;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = this.evaluator.prepareLeftObject(handle);
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, this.evaluator.prepareRightObject(handle));
            this.right = !this.rightNull ? this.extractor.getDoubleValue(workingMemory, this.evaluator.prepareRightObject(handle)) : 0.0;
        }
    }

    public static class CharVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 400L;
        public char left;
        public char right;

        public CharVariableContextEntry() {
        }

        public CharVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readChar();
            this.right = in.readChar();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeChar(this.left);
            out.writeChar(this.right);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
            this.left = !this.leftNull ? this.declaration.getExtractor().getCharValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration))) : (char)'\u0000';
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = this.evaluator.prepareLeftObject(handle);
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, this.evaluator.prepareRightObject(handle));
            this.right = !this.rightNull ? this.extractor.getCharValue(workingMemory, this.evaluator.prepareRightObject(handle)) : (char)'\u0000';
        }
    }

    public static class LongVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 400L;
        public long left;
        public long right;

        public LongVariableContextEntry() {
        }

        public LongVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readLong();
            this.right = in.readLong();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.left);
            out.writeLong(this.right);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
            this.left = !this.leftNull ? this.declaration.getExtractor().getLongValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration))) : 0L;
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = this.evaluator.prepareLeftObject(handle);
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, this.evaluator.prepareRightObject(handle));
            this.right = !this.rightNull ? this.extractor.getLongValue(workingMemory, this.evaluator.prepareRightObject(handle)) : 0L;
        }
    }

    public static class PrimitiveArrayVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 400L;
        public Object left;
        public Object right;

        public PrimitiveArrayVariableContextEntry() {
        }

        public PrimitiveArrayVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readObject();
            this.right = in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.left);
            out.writeObject(this.right);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
            this.left = this.declaration.getExtractor().getValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = this.evaluator.prepareLeftObject(handle);
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, this.evaluator.prepareRightObject(handle));
            this.right = this.extractor.getValue(workingMemory, this.evaluator.prepareRightObject(handle));
        }

        public void resetTuple() {
            this.left = null;
            this.reteTuple = null;
        }

        public void resetFactHandle() {
            this.right = null;
            this.object = null;
        }
    }

    public static class ObjectVariableContextEntry
    extends VariableContextEntry {
        private static final long serialVersionUID = 400L;
        public Object left;
        public Object right;

        public ObjectVariableContextEntry() {
        }

        public ObjectVariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            super(extractor, declaration, evaluator);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.left = in.readObject();
            this.right = in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject(this.left);
            out.writeObject(this.right);
        }

        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.reteTuple = tuple;
            this.workingMemory = workingMemory;
            this.leftNull = this.declaration.getExtractor().isNullValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
            this.left = this.declaration.getExtractor().getValue(workingMemory, this.evaluator.prepareLeftObject(tuple.get(this.declaration)));
        }

        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.object = this.evaluator.prepareLeftObject(handle);
            this.workingMemory = workingMemory;
            this.rightNull = this.extractor.isNullValue(workingMemory, this.evaluator.prepareRightObject(handle));
            this.right = this.extractor.getValue(workingMemory, this.evaluator.prepareRightObject(handle));
        }

        public void resetTuple() {
            this.left = null;
            this.reteTuple = null;
        }

        public void resetFactHandle() {
            this.right = null;
            this.object = null;
        }
    }

    public static abstract class VariableContextEntry
    implements ContextEntry {
        public InternalReadAccessor extractor;
        public Evaluator evaluator;
        public Object object;
        public Declaration declaration;
        public LeftTuple reteTuple;
        public ContextEntry entry;
        public boolean leftNull;
        public boolean rightNull;
        public InternalWorkingMemory workingMemory;

        public VariableContextEntry() {
        }

        public VariableContextEntry(InternalReadAccessor extractor, Declaration declaration, Evaluator evaluator) {
            this.extractor = extractor;
            this.declaration = declaration;
            this.evaluator = evaluator;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.workingMemory = (InternalWorkingMemory)in.readObject();
            this.extractor = (InternalReadAccessor)in.readObject();
            this.evaluator = (Evaluator)in.readObject();
            this.object = in.readObject();
            this.declaration = (Declaration)in.readObject();
            this.reteTuple = (LeftTuple)in.readObject();
            this.entry = (ContextEntry)in.readObject();
            this.leftNull = in.readBoolean();
            this.rightNull = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.workingMemory);
            out.writeObject(this.extractor);
            out.writeObject(this.evaluator);
            out.writeObject(this.object);
            out.writeObject(this.declaration);
            out.writeObject(this.reteTuple);
            out.writeObject(this.entry);
            out.writeBoolean(this.leftNull);
            out.writeBoolean(this.rightNull);
        }

        public ContextEntry getNext() {
            return this.entry;
        }

        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        public ReadAccessor getFieldExtractor() {
            return this.extractor;
        }

        public Object getObject() {
            return this.object;
        }

        public LeftTuple getTuple() {
            return this.reteTuple;
        }

        public Declaration getVariableDeclaration() {
            return this.declaration;
        }

        public boolean isLeftNull() {
            return this.leftNull;
        }

        public boolean isRightNull() {
            return this.rightNull;
        }

        public void resetTuple() {
            this.reteTuple = null;
        }

        public void resetFactHandle() {
            this.object = null;
        }
    }
}

