/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.drools.reteoo.LeftTupleSinkNode;

public class LeftTupleSinkNodeList
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private LeftTupleSinkNode firstNode;
    private LeftTupleSinkNode lastNode;
    private int size;

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.firstNode = (LeftTupleSinkNode)in.readObject();
        this.lastNode = (LeftTupleSinkNode)in.readObject();
        this.size = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.firstNode);
        out.writeObject(this.lastNode);
        out.writeInt(this.size);
    }

    public void add(LeftTupleSinkNode node) {
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
        } else {
            this.lastNode.setNextLeftTupleSinkNode(node);
            node.setPreviousLeftTupleSinkNode(this.lastNode);
            this.lastNode = node;
        }
        ++this.size;
    }

    public void remove(LeftTupleSinkNode node) {
        if (this.firstNode != node && this.lastNode != node) {
            node.getPreviousLeftTupleSinkNode().setNextLeftTupleSinkNode(node.getNextLeftTupleSinkNode());
            node.getNextLeftTupleSinkNode().setPreviousLeftTupleSinkNode(node.getPreviousLeftTupleSinkNode());
            --this.size;
            node.setPreviousLeftTupleSinkNode(null);
            node.setNextLeftTupleSinkNode(null);
        } else if (this.firstNode == node) {
            this.removeFirst();
        } else if (this.lastNode == node) {
            this.removeLast();
        }
    }

    public final LeftTupleSinkNode getFirst() {
        return this.firstNode;
    }

    public final LeftTupleSinkNode getLast() {
        return this.lastNode;
    }

    public LeftTupleSinkNode removeFirst() {
        if (this.firstNode == null) {
            return null;
        }
        LeftTupleSinkNode node = this.firstNode;
        this.firstNode = node.getNextLeftTupleSinkNode();
        node.setNextLeftTupleSinkNode(null);
        if (this.firstNode != null) {
            this.firstNode.setPreviousLeftTupleSinkNode(null);
        } else {
            this.lastNode = null;
        }
        --this.size;
        return node;
    }

    public LeftTupleSinkNode removeLast() {
        if (this.lastNode == null) {
            return null;
        }
        LeftTupleSinkNode node = this.lastNode;
        this.lastNode = node.getPreviousLeftTupleSinkNode();
        node.setPreviousLeftTupleSinkNode(null);
        if (this.lastNode != null) {
            this.lastNode.setNextLeftTupleSinkNode(null);
        } else {
            this.firstNode = this.lastNode;
        }
        --this.size;
        return node;
    }

    public final boolean isEmpty() {
        return this.firstNode == null;
    }

    public void clear() {
        while (this.removeFirst() != null) {
        }
    }

    public final int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new Iterator(){
            private LeftTupleSinkNode currentNode = null;
            private LeftTupleSinkNode nextNode = LeftTupleSinkNodeList.this.getFirst();

            public boolean hasNext() {
                return this.nextNode != null;
            }

            public Object next() {
                this.currentNode = this.nextNode;
                if (this.currentNode == null) {
                    throw new NoSuchElementException("No more elements to return");
                }
                this.nextNode = this.currentNode.getNextLeftTupleSinkNode();
                return this.currentNode;
            }

            public void remove() {
                if (this.currentNode == null) {
                    throw new IllegalStateException("No item to remove. Call next() before calling remove().");
                }
                LeftTupleSinkNodeList.this.remove(this.currentNode);
                this.currentNode = null;
            }
        };
    }
}

