/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.AbstractLeftTupleSinkAdapter;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSinkNodeList;
import org.drools.reteoo.RightTuple;
import org.drools.spi.PropagationContext;

public class CompositeLeftTupleSinkAdapter
extends AbstractLeftTupleSinkAdapter {
    private LeftTupleSinkNodeList sinks;

    public CompositeLeftTupleSinkAdapter() {
        super(RuleBasePartitionId.MAIN_PARTITION);
    }

    public CompositeLeftTupleSinkAdapter(RuleBasePartitionId partitionId) {
        super(partitionId);
        this.sinks = new LeftTupleSinkNodeList();
    }

    public void addTupleSink(LeftTupleSink sink) {
        this.sinks.add((LeftTupleSinkNode)sink);
    }

    public void removeTupleSink(LeftTupleSink sink) {
        this.sinks.remove((LeftTupleSinkNode)sink);
    }

    public void propagateAssertLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            LeftTuple newLeftTuple = new LeftTuple(leftTuple, rightTuple, sink, leftTupleMemoryEnabled);
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, newLeftTuple);
        }
    }

    public void propagateAssertLeftTuple(LeftTuple tuple, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, new LeftTuple(tuple, (LeftTupleSink)sink, leftTupleMemoryEnabled));
        }
    }

    public void createAndPropagateAssertLeftTuple(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory, boolean leftTupleMemoryEnabled) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            this.doPropagateAssertLeftTuple(context, workingMemory, sink, new LeftTuple(factHandle, (LeftTupleSink)sink, leftTupleMemoryEnabled));
        }
    }

    public void propagateRetractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getBetaChildren();
        while (child != null) {
            LeftTuple temp = child.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    public void propagateRetractLeftTupleDestroyRightTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = leftTuple.getBetaChildren();
        while (child != null) {
            LeftTuple temp = child.getLeftParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            workingMemory.getFactHandleFactory().destroyFactHandle(child.getRightParent().getFactHandle());
            child.unlinkFromRightParent();
            child.unlinkFromLeftParent();
            child = temp;
        }
    }

    public void propagateRetractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple child = rightTuple.getBetaChildren();
        while (child != null) {
            LeftTuple temp = child.getRightParentNext();
            this.doPropagateRetractLeftTuple(context, workingMemory, child, child.getLeftTupleSink());
            child.unlinkFromLeftParent();
            child.unlinkFromRightParent();
            child = temp;
        }
    }

    public BaseNode getMatchingNode(BaseNode candidate) {
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            if (!candidate.equals(sink)) continue;
            return (BaseNode)((Object)sink);
        }
        return null;
    }

    public LeftTupleSink[] getSinks() {
        LeftTupleSink[] sinkArray = new LeftTupleSink[this.sinks.size()];
        int i = 0;
        for (LeftTupleSinkNode sink = this.sinks.getFirst(); sink != null; sink = sink.getNextLeftTupleSinkNode()) {
            sinkArray[i++] = sink;
        }
        return sinkArray;
    }

    public int size() {
        return this.sinks.size();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sinks = (LeftTupleSinkNodeList)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sinks);
    }

    protected void doPropagateAssertLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTupleSinkNode sink, LeftTuple leftTuple) {
        sink.assertLeftTuple(leftTuple, context, workingMemory);
    }

    protected void doPropagateRetractLeftTuple(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, LeftTupleSink sink) {
        sink.retractLeftTuple(leftTuple, context, workingMemory);
    }
}

