/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.command;

import java.util.List;
import org.drools.command.Setter;
import org.drools.process.command.Command;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.runtime.rule.FactHandle;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyCommand
implements Command<Object> {
    private FactHandle handle;
    private List<Setter> setters;

    public ModifyCommand(FactHandle handle, List<Setter> setters) {
        this.handle = handle;
        this.setters = setters;
    }

    @Override
    public Object execute(ReteooWorkingMemory session) {
        Object object = session.getObject(this.handle);
        MVEL.eval((String)this.getMvelExpr(), (Object)object);
        session.update(this.handle, object);
        return object;
    }

    public FactHandle getFactHandle() {
        return this.handle;
    }

    public List<Setter> getSetters() {
        return this.setters;
    }

    private String getMvelExpr() {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("with (this) {\n");
        int i = 0;
        for (Setter setter : this.setters) {
            if (i++ > 0) {
                sbuilder.append(",");
            }
            sbuilder.append(setter.getAccessor() + " = " + setter.getValue() + "\n");
        }
        sbuilder.append("}");
        return sbuilder.toString();
    }

    public String toString() {
        return "modify() " + this.getMvelExpr();
    }

    public static class SetterImpl
    implements Setter {
        private String accessor;
        private String value;

        public SetterImpl(String accessor, String value) {
            this.accessor = accessor;
            this.value = value;
        }

        public String getAccessor() {
            return this.accessor;
        }

        public String getValue() {
            return this.value;
        }
    }
}

