/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.connector;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.connector.InteractionImplementor;
import com.mockrunner.mock.connector.cci.MockStreamableByteArrayRecord;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.Streamable;

public class StreamableRecordByteArrayInteraction
implements InteractionImplementor {
    private boolean enabled;
    private byte[] expectedRequest;
    private byte[] responseData;
    private Class responseClass;
    private Record responseRecord;

    public StreamableRecordByteArrayInteraction() {
        this(null, null, MockStreamableByteArrayRecord.class);
    }

    public StreamableRecordByteArrayInteraction(byte[] byArray) {
        this(null, byArray, MockStreamableByteArrayRecord.class);
    }

    public StreamableRecordByteArrayInteraction(byte[] byArray, byte[] byArray2) {
        this(byArray, byArray2, MockStreamableByteArrayRecord.class);
    }

    public StreamableRecordByteArrayInteraction(byte[] byArray, Class clazz) {
        this(null, byArray, clazz);
    }

    public StreamableRecordByteArrayInteraction(byte[] byArray, byte[] byArray2, Class clazz) {
        this.setExpectedRequest(byArray);
        this.setResponse(byArray2, clazz);
        this.enabled = true;
    }

    public StreamableRecordByteArrayInteraction(byte[] byArray, Record record) {
        this.setExpectedRequest(byArray);
        this.setResponse(record);
        this.enabled = true;
    }

    public StreamableRecordByteArrayInteraction(Record record) {
        this(null, record);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void setExpectedRequest(byte[] byArray) {
        this.expectedRequest = (byte[])(null == byArray ? null : (byte[])byArray.clone());
    }

    public void setExpectedRequest(InputStream inputStream) {
        this.expectedRequest = (byte[])(null == inputStream ? null : StreamUtil.getStreamAsByteArray(inputStream));
    }

    public void setResponse(byte[] byArray) {
        this.setResponse(byArray, MockStreamableByteArrayRecord.class);
    }

    public void setResponse(byte[] byArray, Class clazz) {
        if (!this.isResponseClassAcceptable(clazz)) {
            throw new IllegalArgumentException("responseClass must implement " + Streamable.class.getName() + " and " + Record.class.getName());
        }
        this.responseData = (byte[])(null == byArray ? null : (byte[])byArray.clone());
        this.responseClass = clazz;
    }

    public void setResponse(InputStream inputStream) {
        this.setResponse(inputStream, MockStreamableByteArrayRecord.class);
    }

    public void setResponse(InputStream inputStream, Class clazz) {
        if (!this.isResponseClassAcceptable(clazz)) {
            throw new IllegalArgumentException("responseClass must implement " + Streamable.class.getName() + " and " + Record.class.getName());
        }
        this.responseData = (byte[])(null == inputStream ? null : StreamUtil.getStreamAsByteArray(inputStream));
        this.responseClass = clazz;
    }

    public void setResponse(Record record) {
        this.responseRecord = record;
    }

    public boolean canHandle(InteractionSpec interactionSpec, Record record, Record record2) {
        if (!this.enabled) {
            return false;
        }
        if (!this.isResponseAcceptable(record2)) {
            return false;
        }
        return this.doesRequestMatch(record);
    }

    private boolean doesRequestMatch(Record record) {
        if (null == this.expectedRequest) {
            return true;
        }
        if (null == record) {
            return false;
        }
        if (record instanceof Streamable) {
            try {
                Streamable streamable = (Streamable)record;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                streamable.write((OutputStream)byteArrayOutputStream);
                byteArrayOutputStream.flush();
                return Arrays.equals(this.expectedRequest, byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                throw new NestedApplicationException(exception);
            }
        }
        return false;
    }

    private boolean isResponseAcceptable(Record record) {
        return null == record || record instanceof Streamable;
    }

    private boolean isResponseClassAcceptable(Class clazz) {
        return null == clazz || Streamable.class.isAssignableFrom(clazz) && Record.class.isAssignableFrom(clazz);
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        if (!this.canHandle(interactionSpec, record, null)) {
            return null;
        }
        if (null != this.responseRecord) {
            return this.responseRecord;
        }
        MockStreamableByteArrayRecord mockStreamableByteArrayRecord = null;
        try {
            mockStreamableByteArrayRecord = null == this.responseClass ? new MockStreamableByteArrayRecord() : (Streamable)this.responseClass.newInstance();
            if (null != this.responseData) {
                mockStreamableByteArrayRecord.read(new ByteArrayInputStream(this.responseData));
            }
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException("execute() failed");
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
        return mockStreamableByteArrayRecord;
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        if (!this.canHandle(interactionSpec, record, record2)) {
            return false;
        }
        try {
            if (null != this.responseData && null != record2) {
                ((Streamable)record2).read((InputStream)new ByteArrayInputStream(this.responseData));
            }
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException("execute() failed");
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
        return true;
    }
}

