/*
 * Decompiled with CFR 0.152.
 */
package org.mockejb.jms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.mockejb.interceptor.InterceptableProxy;
import org.mockejb.jms.MessageImpl;
import org.mockejb.jms.MessageUtility;
import org.mockejb.jms.MockDestination;
import org.mockejb.jms.MockSession;

public class MockConsumer
implements MessageConsumer {
    private boolean closed = false;
    private MockSession sess;
    private MockDestination destination;
    private final List messages = new ArrayList();
    private MessageListener listener = null;
    static /* synthetic */ Class class$javax$jms$MessageListener;

    MockConsumer(MockSession sess, MockDestination destination) {
        this.sess = sess;
        this.destination = destination;
    }

    public String getMessageSelector() throws JMSException {
        return null;
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.listener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.listener = (MessageListener)InterceptableProxy.create(class$javax$jms$MessageListener == null ? (class$javax$jms$MessageListener = MockConsumer.class$("javax.jms.MessageListener")) : class$javax$jms$MessageListener, listener);
    }

    public Message receive() throws JMSException {
        if (this.isClosed()) {
            return null;
        }
        if (this.messages.size() == 0) {
            throw new RuntimeException("No messages received");
        }
        return (Message)this.messages.remove(0);
    }

    public Message receive(long timeout) throws JMSException {
        if (this.isClosed() || this.messages.size() == 0 && timeout != 0L) {
            return null;
        }
        return this.receive();
    }

    public Message receiveNoWait() throws JMSException {
        return this.receive(1L);
    }

    public void close() throws JMSException {
        this.closed = true;
        this.destination.removeConsumer(this);
        this.messages.clear();
        this.listener = null;
        this.destination = null;
    }

    void consume() throws JMSException {
        if (this.listener == null || this.messages.size() == 0) {
            return;
        }
        ListIterator it = this.messages.listIterator();
        System.out.println("Consuming...");
        while (it.hasNext()) {
            try {
                this.listener.onMessage((Message)it.next());
            }
            catch (Throwable t) {
                throw new RuntimeException("Escaped exception from MessageListener (faulty listener):\n" + t.getMessage());
            }
            it.remove();
        }
    }

    void consume(Message msg) throws JMSException {
        MessageImpl receivedMsg = MessageUtility.copyMessage(msg, true);
        MessageListener l = this.getMessageListener();
        if (l != null && this.isStarted()) {
            try {
                l.onMessage((Message)receivedMsg);
            }
            catch (Throwable t) {
                throw new RuntimeException("Escaped exception from MessageListener (faulty listener):\n" + t.getMessage());
            }
        } else {
            this.messages.add(receivedMsg);
        }
    }

    void consume(Collection messages) throws JMSException {
        Iterator it = messages.iterator();
        while (it.hasNext()) {
            this.consume((Message)it.next());
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    MockDestination getDestination() {
        return this.destination;
    }

    private boolean isStarted() {
        return this.sess.getConnection().isStarted();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

