/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.task.comments;

import java.util.List;
import org.jbpm.api.history.HistoryComment;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskCommentsTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/task/comments/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testTaskComments() {
        this.executionService.startProcessInstanceByKey("TaskComments");
        List taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCommentsTest.assertEquals((int)1, (int)taskList.size());
        String taskId = ((Task)taskList.get(0)).getId();
        this.taskService.addTaskComment(taskId, "hi");
        this.taskService.addTaskComment(taskId, "yo");
        List comments = this.taskService.getTaskComments(taskId);
        TaskCommentsTest.assertEquals((String)("expected 2 comments: " + comments), (int)2, (int)comments.size());
        TaskCommentsTest.assertEquals((String)"hi", (String)((HistoryComment)comments.get(0)).getMessage());
        TaskCommentsTest.assertEquals((String)"yo", (String)((HistoryComment)comments.get(1)).getMessage());
    }
}

