/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.mail.inline;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.jbpm.test.JbpmTestCase;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class InlineMailTest
extends JbpmTestCase {
    private Wiser wiser = new Wiser();

    protected void setUp() throws Exception {
        super.setUp();
        String deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/mail/inline/process.jpdl.xml").deploy();
        this.registerDeployment(deploymentId);
        this.identityService.createUser("bb", "Big Brother", null, "bb@oceania");
        this.identityService.createUser("obrien", null, "O'Brien", "obrien@miniluv");
        this.identityService.createUser("charr", null, "Charrington", "charr@miniluv");
        this.identityService.createGroup("thinkpol");
        this.identityService.createGroup("innerparty");
        this.identityService.createMembership("obrien", "innerparty");
        this.identityService.createMembership("charr", "thinkpol");
        this.identityService.createMembership("obrien", "thinkpol");
        this.wiser.setPort(2525);
        this.wiser.start();
    }

    protected void tearDown() throws Exception {
        this.wiser.stop();
        this.identityService.deleteUser("bb");
        this.identityService.deleteUser("obrien");
        this.identityService.deleteUser("charr");
        this.identityService.deleteGroup("thinkpol");
        this.identityService.deleteGroup("innerparty");
        super.tearDown();
    }

    public void testInlineMail() throws MessagingException, IOException {
        String newspaper = "times";
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1983, 11, 3);
        Date date = calendar.getTime();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("newspaper", newspaper);
        variables.put("date", date);
        this.executionService.startProcessInstanceByKey("InlineMail", variables);
        List wisMessages = this.wiser.getMessages();
        InlineMailTest.assertEquals((int)5, (int)wisMessages.size());
        for (WiserMessage wisMessage : wisMessages) {
            MimeMessage message = wisMessage.getMimeMessage();
            Address[] from = message.getFrom();
            InlineMailTest.assertEquals((int)1, (int)from.length);
            InlineMailTest.assertEquals((String)"noreply@jbpm.org", (String)from[0].toString());
            Object[] expectedTo = InternetAddress.parse((String)"winston@minitrue");
            Object[] to = message.getRecipients(Message.RecipientType.TO);
            assert (Arrays.equals(expectedTo, to)) : Arrays.toString(to);
            Object[] expectedCc = InternetAddress.parse((String)"bb@oceania, obrien@miniluv");
            System.out.println(Arrays.toString(expectedCc));
            Object[] cc = message.getRecipients(Message.RecipientType.CC);
            System.out.println(Arrays.toString(cc));
            assert (Arrays.equals(expectedCc, cc)) : Arrays.toString(cc);
            InlineMailTest.assertNull((Object)message.getRecipients(Message.RecipientType.BCC));
            InlineMailTest.assertEquals((String)("rectify " + newspaper), (String)message.getSubject());
            this.assertTextPresent(newspaper + ' ' + date + " reporting bb dayorder", (String)message.getContent());
        }
    }
}

