/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.bpmn.gateway.parallel;

import java.util.List;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class ParallelGatewayTest
extends JbpmTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        NewDeployment deployment = this.repositoryService.createDeployment();
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/gateway/parallel/parallel_gateway.bpmn.xml");
        this.registerDeployment(deployment.deploy());
    }

    public void testParallelGateway() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("parallelGateway");
        List tasks = this.taskService.createTaskQuery().list();
        ParallelGatewayTest.assertEquals((int)2, (int)tasks.size());
        this.taskService.completeTask(((Task)tasks.get(0)).getId());
        this.assertProcessInstanceActive(processInstance);
        Task secondTask = this.taskService.createTaskQuery().uniqueResult();
        ParallelGatewayTest.assertNotNull((Object)secondTask);
        ParallelGatewayTest.assertTrue((secondTask.getName().equals("Prepare shipment") || secondTask.getName().equals("Bill customer") ? 1 : 0) != 0);
        this.taskService.completeTask(secondTask.getId());
        this.assertProcessInstanceEnded(processInstance);
    }
}

