/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.history;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class AvgDurationTest
extends JbpmTestCase {
    static DateFormat dateFormat = new SimpleDateFormat("ss,SSS");

    public void testAvgDuration() throws Exception {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='one' />  </start>  <state name='one'>    <transition to='two' />  </state>  <state name='two'>    <transition to='three' />  </state>  <state name='three'>    <transition to='end' />  </state>  <end name='end' /></process>");
        this.executeProcess();
        this.executeProcess();
        this.executeProcess();
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().uniqueResult();
        Map avgDurations = this.historyService.avgDurationPerActivity(processDefinition.getId());
        Number avgDurationOne = (Number)avgDurations.get("one");
        AvgDurationTest.assertNotNull((Object)avgDurationOne);
        AvgDurationTest.assertTrue((String)("expected avg duration bigger then 40, but was " + avgDurationOne), (avgDurationOne.intValue() > 40 ? 1 : 0) != 0);
        Number avgDurationTwo = (Number)avgDurations.get("two");
        AvgDurationTest.assertNotNull((Object)avgDurationTwo);
        AvgDurationTest.assertTrue((String)("expected avg duration bigger then 10, but was " + avgDurationTwo), (avgDurationTwo.intValue() > 10 ? 1 : 0) != 0);
        Number avgDurationThree = (Number)avgDurations.get("three");
        AvgDurationTest.assertNotNull((Object)avgDurationThree);
        AvgDurationTest.assertTrue((String)("expected avg duration bigger then 0, but was " + avgDurationThree), (avgDurationThree.intValue() >= 0 ? 1 : 0) != 0);
        AvgDurationTest.assertEquals((int)3, (int)avgDurations.size());
    }

    protected void executeProcess() throws InterruptedException {
        ProcessInstance execution = this.executionService.startProcessInstanceByKey("ICL");
        this.log.info("waiting 50 millis at " + dateFormat.format(new Date()));
        try {
            Thread.sleep(50L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.info("done waiting 50 millis at " + dateFormat.format(new Date()));
        this.executionService.signalExecutionById(execution.getId());
        this.log.info("waiting 20 millis at " + dateFormat.format(new Date()));
        try {
            Thread.sleep(20L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.info("done waiting 20 millis at " + dateFormat.format(new Date()));
        this.executionService.signalExecutionById(execution.getId());
        this.executionService.signalExecutionById(execution.getId());
    }
}

