/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.execution;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class SignalExecutionTest
extends JbpmTestCase {
    public void testSignalExecutionById() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />  </state>  <state name='b'>    <transition to='c' />  </state>  <state name='c' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", "82436");
        SignalExecutionTest.assertTrue((boolean)processInstance.isActive("a"));
        processInstance = this.executionService.signalExecutionById("ICL.82436");
        SignalExecutionTest.assertTrue((boolean)processInstance.isActive("b"));
        processInstance = this.executionService.signalExecutionById("ICL.82436");
        SignalExecutionTest.assertTrue((boolean)processInstance.isActive("c"));
    }

    public void testSignalExecutionWithVariables() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />  </state>  <state name='b' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", "82436");
        Map<String, Object> variables = new HashMap<String, Object>();
        variables.put("customer", "John Doe");
        variables.put("type", "Accident");
        variables.put("amount", new Float(763.74));
        processInstance = this.executionService.signalExecutionById("ICL.82436", variables);
        SignalExecutionTest.assertNotNull((Object)processInstance);
        String pid = processInstance.getId();
        SignalExecutionTest.assertTrue((boolean)processInstance.isActive("b"));
        HashMap expectedVariables = new HashMap(variables);
        HashSet expectedVariableNames = new HashSet(expectedVariables.keySet());
        HashSet variableNames = new HashSet(this.executionService.getVariableNames(pid));
        SignalExecutionTest.assertEquals(expectedVariableNames, variableNames);
        variables = this.executionService.getVariables(pid, variableNames);
        SignalExecutionTest.assertEquals(expectedVariables, variables);
    }

    public void testDefaultSignalWithoutTransitions() {
        this.deployJpdlXmlString("<process name='p'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("p");
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        SignalExecutionTest.assertTrue((boolean)processInstance.isActive("a"));
    }
}

