/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.task;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskCandidatesTest
extends JbpmTestCase {
    public void testCommaSeparatedTaskCandidates() {
        this.deployJpdlXmlString("<process name='TaskCandidates'>  <start>    <transition to='review' />  </start>  <task name='review'         candidate-users='johndoe, joesmoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TaskCandidates");
        String pid = processInstance.getId();
        List taskList = this.taskService.findGroupTasks("johndoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        taskList = this.taskService.findGroupTasks("joesmoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findPersonalTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        this.taskService.takeTask(task.getId(), "johndoe");
        taskList = this.taskService.findGroupTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findGroupTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        TaskCandidatesTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        taskList = this.taskService.findPersonalTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        this.taskService.completeTask(task.getId());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        processInstance = this.executionService.findProcessInstanceById(pid);
        TaskCandidatesTest.assertTrue((boolean)processInstance.isActive("wait"));
    }

    public void testTaskCandidatesExpression() {
        this.deployJpdlXmlString("<process name='TaskCandidates'>  <start>    <transition to='review' />  </start>  <task name='review'         candidate-users='#{userone}, #{usertwo}'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("userone", "johndoe");
        variables.put("usertwo", "joesmoe");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TaskCandidates", variables);
        String executionId = processInstance.getId();
        List taskList = this.taskService.findGroupTasks("johndoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        taskList = this.taskService.findGroupTasks("joesmoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findPersonalTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        this.taskService.takeTask(task.getId(), "johndoe");
        taskList = this.taskService.findGroupTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findGroupTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((String)"Expected a single task being created", (int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        TaskCandidatesTest.assertEquals((String)"review", (String)task.getName());
        TaskCandidatesTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        taskList = this.taskService.findPersonalTasks("joesmoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        this.taskService.completeTask(task.getId());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskCandidatesTest.assertEquals((int)0, (int)taskList.size());
        processInstance = this.executionService.findProcessInstanceById(executionId);
        TaskCandidatesTest.assertTrue((boolean)processInstance.isActive("wait"));
    }

    public void testCandidatePutsTaskBackInGroup() {
        this.deployJpdlXmlString("<process name='CandidatePutsTaskBackInGroup'>  <start>    <transition to='review' />  </start>  <task name='review'         candidate-groups='sales-dept'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("CandidatePutsTaskBackInGroup");
        String pid = processInstance.getId();
        Task task = this.taskService.createTaskQuery().processInstanceId(pid).uniqueResult();
        TaskCandidatesTest.assertNull((Object)task.getAssignee());
        this.taskService.takeTask(task.getId(), "johndoe");
        task = this.taskService.createTaskQuery().processInstanceId(pid).uniqueResult();
        TaskCandidatesTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        this.taskService.assignTask(task.getId(), null);
        task = this.taskService.getTask(task.getId());
        TaskCandidatesTest.assertNull((Object)task.getAssignee());
    }

    public void testDoubleTake() {
        this.deployJpdlXmlString("<process name='DoubleTake'>  <start>    <transition to='review' />  </start>  <task name='review'         candidate-users='johndoe, joesmoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("DoubleTake");
        String pid = processInstance.getId();
        String taskId = ((Task)this.taskService.findGroupTasks("johndoe").get(0)).getId();
        this.taskService.takeTask(taskId, "johndoe");
        try {
            this.taskService.takeTask(taskId, "joesmoe");
        }
        catch (JbpmException e) {
            this.assertTextPresent("task already taken by johndoe", e.getMessage());
        }
    }
}

