/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class ForkTest
extends JbpmTestCase {
    private static final String UNSTRUCTURED_CONCURRENT_PROCESS = "<process name='unstructuredConcurrency'><start name='start'>    <transition to='theFork'/> </start> <fork name='theFork'>    <transition name='pathA' to='A'/>    <transition name='pathB' to='B'/> </fork> <task name='A'>    <transition to='theJoin'/> </task> <task name='B'>    <transition to='end2'/> </task> <join name='theJoin'>    <transition to='waitState'/> </join> <state name='waitState'>  <transition to='end1' /></state><end name='end1'/> <end name='end2'/> </process>";

    public void testBasicForkUsage() {
        this.deployJpdlXmlString("<process name='sboxCreation'><start name='start'>    <transition to='fork (review)'/> </start> <fork name='fork (review)'>    <transition name='Reporting review' to='Review (risk)'/>    <transition name='Risk review' to='Review (reporting)'/> </fork> <task candidate-groups='risk-dept' name='Review (risk)'>    <transition name='Approve'  to='join (approved)'/>    <transition name='Reject'   to='Rejected by Risk'/> </task> <task candidate-groups='reporting-dept' name='Review (reporting)'>    <transition name='Approve' to='join (approved)'/>    <transition name='Reject' to='Rejected by Reporting'/> </task> <join name='join (approved)'>    <transition to='end1'/> </join> <end-cancel name='Rejected by Reporting'/> <end name='end1'/> <end-cancel name='Rejected by Risk'/> </process>");
        String processInstanceId = this.executionService.startProcessInstanceByKey("sboxCreation").getId();
        Task riskTask = this.taskService.createTaskQuery().activityName("Review (risk)").uniqueResult();
        Task reportTask = this.taskService.createTaskQuery().activityName("Review (reporting)").uniqueResult();
        this.taskService.completeTask(riskTask.getId(), "Approve");
        this.taskService.completeTask(reportTask.getId(), "Reject");
        this.assertProcessInstanceEnded(processInstanceId);
    }

    public void testDefaultUnstructuredForkBehaviour() {
        this.deployJpdlXmlString(UNSTRUCTURED_CONCURRENT_PROCESS);
        String processInstanceId = this.executionService.startProcessInstanceByKey("unstructuredConcurrency").getId();
        Task taskA = this.taskService.createTaskQuery().activityName("A").uniqueResult();
        this.taskService.completeTask(taskA.getId());
        this.assertActivitiesActive(processInstanceId, new String[]{"waitState", "B"});
        Task taskB = this.taskService.createTaskQuery().activityName("B").uniqueResult();
        this.taskService.completeTask(taskB.getId());
        this.assertProcessInstanceEnded(processInstanceId);
    }

    public void testDefaultUnstructuredForkBehaviour2() {
        this.deployJpdlXmlString(UNSTRUCTURED_CONCURRENT_PROCESS);
        String processInstanceId = this.executionService.startProcessInstanceByKey("unstructuredConcurrency").getId();
        Task taskB = this.taskService.createTaskQuery().activityName("B").uniqueResult();
        this.taskService.completeTask(taskB.getId());
        this.assertProcessInstanceEnded(processInstanceId);
        ForkTest.assertTrue((String)"There are still open tasks left", (boolean)this.taskService.createTaskQuery().processInstanceId(processInstanceId).list().isEmpty());
    }

    public void testUnstructuredForkBehaviourWhenEndingExecutionOnly() {
        this.deployJpdlXmlString(this.addEndExecutionToConcurrentProcess());
        String processInstanceId = this.executionService.startProcessInstanceByKey("unstructuredConcurrency").getId();
        Task taskB = this.taskService.createTaskQuery().activityName("B").uniqueResult();
        this.taskService.completeTask(taskB.getId());
        this.assertProcessInstanceActive(processInstanceId);
        this.assertActivityActive(processInstanceId, "A");
        Task taskA = this.taskService.createTaskQuery().activityName("A").uniqueResult();
        this.taskService.completeTask(taskA.getId());
        this.assertActivityActive(processInstanceId, "waitState");
        this.assertProcessInstanceActive(processInstanceId);
        this.executionService.signalExecutionById(this.executionService.findExecutionById(processInstanceId).findActiveExecutionIn("waitState").getId());
        this.assertProcessInstanceEnded(processInstanceId);
    }

    public void testUnstructuredForkBehaviourWhenEndingExecutionOnly2() {
        this.deployJpdlXmlString(this.addEndExecutionToConcurrentProcess());
        String processInstanceId = this.executionService.startProcessInstanceByKey("unstructuredConcurrency").getId();
        Task taskA = this.taskService.createTaskQuery().activityName("A").uniqueResult();
        this.taskService.completeTask(taskA.getId());
        this.assertActivitiesActive(processInstanceId, new String[]{"B", "waitState"});
        Task taskB = this.taskService.createTaskQuery().activityName("B").uniqueResult();
        this.taskService.completeTask(taskB.getId());
        this.assertProcessInstanceActive(processInstanceId);
    }

    private String addEndExecutionToConcurrentProcess() {
        return UNSTRUCTURED_CONCURRENT_PROCESS.replace("<end name='end1'/>", "<end name='end1' ends='execution'/>").replace("<end name='end2'/>", "<end name='end2' ends='execution'/>");
    }
}

