/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn.test.startevent;

import java.util.Date;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.ProcessInstanceQuery;
import org.jbpm.api.job.Job;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.util.DateUtils;

public class TimerStartEventTest
extends JbpmTestCase {
    private static final String INVALID_PROCESS_1 = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='invalidProcess1'>    <startEvent id='theStart' >      <timerEventDefinition />    </startEvent>    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String INVALID_PROCESS_2 = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='invalidProcess1'>    <startEvent id='theStart' >      <timerEventDefinition >        <timeCycle>5 hours</timeCycle>        <timeDate>10/10/1985</timeDate>      </timerEventDefinition>    </startEvent>    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String INVALID_PROCESS_3 = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='invalidProcess1'>    <startEvent id='theStart' >      <timerEventDefinition >        <timeCycle>5 abcdefghijklmnop</timeCycle>      </timerEventDefinition>    </startEvent>    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String INVALID_PROCESS_4 = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='invalidProcess1'>    <startEvent id='theStart' >      <timerEventDefinition >        <timeCycle>Z 0 22 * * ?</timeCycle>      </timerEventDefinition>    </startEvent>    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TIMER_START_FIXED_DUEDATE = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='timerStartFixedDueDate'>    <startEvent id='theStart' >      <timerEventDefinition >        <timeDate>10/10/2099 00:00:00</timeDate>      </timerEventDefinition>    </startEvent>    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='wait' />    <receiveTask id='wait' />    <sequenceFlow id='flow2' sourceRef='wait' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TIMER_START_TIMECYCLE_DURATION = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='timerStartTimeCycleDuration'>    <startEvent id='theStart' >      <timerEventDefinition >        <timeCycle>10 hours</timeCycle>      </timerEventDefinition>    </startEvent>    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='wait' />    <receiveTask id='wait' />    <sequenceFlow id='flow2' sourceRef='wait' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";
    private static final String TIMER_START_TIMECYCLE_CRON_EXPR = "<definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <process id='timerStartTimeCycleCronExpression' name='timerStartCron'>    <startEvent id='theStart' >      <timerEventDefinition >        <timeCycle>0 0 22 * * ?</timeCycle>      </timerEventDefinition>    </startEvent>    <sequenceFlow id='flow1' sourceRef='theStart' targetRef='wait' />    <receiveTask id='wait' />    <sequenceFlow id='flow2' sourceRef='wait' targetRef='theEnd' />    <endEvent id='theEnd' />  </process></definitions>";

    protected void tearDown() throws Exception {
        Clock.setExplicitTime(null);
        super.tearDown();
    }

    public void testInvalidProcess() {
        this.testDeployInvalidProcess(INVALID_PROCESS_1);
        this.testDeployInvalidProcess(INVALID_PROCESS_2);
        this.testDeployInvalidProcess(INVALID_PROCESS_3);
        this.testDeployInvalidProcess(INVALID_PROCESS_4);
    }

    private void testDeployInvalidProcess(String process) {
        try {
            this.deployBpmn2XmlString(process);
            TimerStartEventTest.fail();
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    public void testTimerStartEventWithFixedDuedate() {
        this.deployBpmn2XmlString(TIMER_START_FIXED_DUEDATE);
        Job startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartEventTest.assertNotNull((Object)startProcessTimer);
        TimerStartEventTest.assertEquals((long)DateUtils.getDateAtMidnight((int)10, (int)9, (int)2099).getTime(), (long)startProcessTimer.getDueDate().getTime());
        ProcessInstanceQuery procInstQuery = this.executionService.createProcessInstanceQuery().processDefinitionId(this.findProcessDefinitionId("timerStartFixedDueDate"));
        TimerStartEventTest.assertEquals((long)0L, (long)procInstQuery.count());
        this.managementService.executeJob(startProcessTimer.getId());
        TimerStartEventTest.assertEquals((long)1L, (long)procInstQuery.count());
        startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartEventTest.assertNull((Object)startProcessTimer);
    }

    public void testTimerStartEventWithDurationAsTimeCycle() {
        Clock.setExplicitTime((Date)DateUtils.getDateAtMidnight((int)10, (int)9, (int)2099));
        this.deployBpmn2XmlString(TIMER_START_TIMECYCLE_DURATION);
        Job startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartEventTest.assertNotNull((Object)startProcessTimer);
        TimerStartEventTest.assertEquals((long)DateUtils.getDate((int)10, (int)9, (int)2099, (int)10, (int)0, (int)0).getTime(), (long)startProcessTimer.getDueDate().getTime());
        ProcessInstanceQuery procInstQuery = this.executionService.createProcessInstanceQuery().processDefinitionId(this.findProcessDefinitionId("timerStartTimeCycleDuration"));
        TimerStartEventTest.assertEquals((long)0L, (long)procInstQuery.count());
        Clock.setExplicitTime((Date)DateUtils.getDate((int)10, (int)9, (int)2099, (int)10, (int)0, (int)0));
        this.managementService.executeJob(startProcessTimer.getId());
        TimerStartEventTest.assertEquals((long)1L, (long)procInstQuery.count());
        startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartEventTest.assertEquals((long)DateUtils.getDate((int)10, (int)9, (int)2099, (int)20, (int)0, (int)0).getTime(), (long)startProcessTimer.getDueDate().getTime());
        this.managementService.deleteJob(Long.valueOf(startProcessTimer.getId()).longValue());
    }

    public void testTimerStartEventWithCronExpressionAsTimeCycle() {
        Clock.setExplicitTime((Date)DateUtils.getDateAtMidnight((int)10, (int)9, (int)2099));
        this.deployBpmn2XmlString(TIMER_START_TIMECYCLE_CRON_EXPR);
        Job startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartEventTest.assertNotNull((Object)startProcessTimer);
        TimerStartEventTest.assertEquals((long)DateUtils.getDate((int)10, (int)9, (int)2099, (int)22, (int)0, (int)0).getTime(), (long)startProcessTimer.getDueDate().getTime());
        ProcessInstanceQuery procInstQuery = this.executionService.createProcessInstanceQuery().processDefinitionId(this.findProcessDefinitionId("timerStartTimeCycleCronExpression"));
        TimerStartEventTest.assertEquals((long)0L, (long)procInstQuery.count());
        Clock.setExplicitTime((Date)DateUtils.getDate((int)10, (int)9, (int)2099, (int)22, (int)0, (int)0));
        this.managementService.executeJob(startProcessTimer.getId());
        TimerStartEventTest.assertEquals((long)1L, (long)procInstQuery.count());
        startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartEventTest.assertEquals((long)DateUtils.getDate((int)11, (int)9, (int)2099, (int)22, (int)0, (int)0).getTime(), (long)startProcessTimer.getDueDate().getTime());
        this.managementService.deleteJob(Long.valueOf(startProcessTimer.getId()).longValue());
    }

    public void testDeleteProcessDefinitionBeforeTimerTriggers() {
        Clock.setExplicitTime((Date)DateUtils.getDateAtMidnight((int)10, (int)9, (int)2099));
        String deployId = this.deployBpmn2XmlString(TIMER_START_TIMECYCLE_DURATION);
        String procDefId = this.findProcessDefinitionId("timerStartTimeCycleDuration");
        this.repositoryService.deleteDeploymentCascade(deployId);
        this.registeredDeployments.remove(0);
        Job startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartEventTest.assertNotNull((Object)startProcessTimer);
        ProcessInstanceQuery procInstQuery = this.executionService.createProcessInstanceQuery().processDefinitionId(procDefId);
        TimerStartEventTest.assertEquals((long)0L, (long)procInstQuery.count());
        this.managementService.executeJob(startProcessTimer.getId());
        startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        TimerStartEventTest.assertNull((Object)startProcessTimer);
        TimerStartEventTest.assertEquals((long)0L, (long)procInstQuery.count());
    }

    public void testStartProcessInstanceByKey() {
        this.deployBpmn2XmlString(TIMER_START_TIMECYCLE_DURATION);
        ProcessInstance pi = this.executionService.startProcessInstanceByKey("timerStartTimeCycleDuration");
        TimerStartEventTest.assertNotNull((Object)pi);
        Job startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        this.managementService.deleteJob(Long.valueOf(startProcessTimer.getId()).longValue());
    }

    public void testOnlyOneStartProcessActiveAfterRedeploy() {
        this.deployBpmn2XmlString(TIMER_START_TIMECYCLE_DURATION);
        List startProcessTimers = this.managementService.createJobQuery().list();
        TimerStartEventTest.assertEquals((int)1, (int)startProcessTimers.size());
        String firstJobId = ((Job)startProcessTimers.get(0)).getId();
        this.deployBpmn2XmlString(TIMER_START_TIMECYCLE_DURATION);
        TimerStartEventTest.assertEquals((int)2, (int)this.repositoryService.createProcessDefinitionQuery().list().size());
        startProcessTimers = this.managementService.createJobQuery().list();
        TimerStartEventTest.assertEquals((int)1, (int)startProcessTimers.size());
        String secondJobId = ((Job)startProcessTimers.get(0)).getId();
        TimerStartEventTest.assertTrue((!firstJobId.equals(secondJobId) ? 1 : 0) != 0);
        this.managementService.deleteJob(Long.valueOf(secondJobId).longValue());
    }

    public void testLatestProcessDefinitionUsedAfterRedeploy() {
        this.deployBpmn2XmlString(TIMER_START_TIMECYCLE_DURATION);
        Job startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        this.deployBpmn2XmlString(TIMER_START_TIMECYCLE_DURATION);
        List procDefs = this.repositoryService.createProcessDefinitionQuery().orderAsc("versionProperty.longValue").list();
        TimerStartEventTest.assertEquals((int)2, (int)procDefs.size());
        startProcessTimer = this.managementService.createJobQuery().uniqueResult();
        this.managementService.executeJob(startProcessTimer.getId());
        ProcessInstance procInst = this.executionService.createProcessInstanceQuery().uniqueResult();
        TimerStartEventTest.assertEquals((String)((ProcessDefinition)procDefs.get(1)).getId(), (String)procInst.getProcessDefinitionId());
        this.managementService.deleteJob(Long.valueOf(startProcessTimer.getId()).longValue());
    }

    private String findProcessDefinitionId(String processDefinitionKey) {
        return this.repositoryService.createProcessDefinitionQuery().processDefinitionName(processDefinitionKey).uniqueResult().getId();
    }
}

