/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.drools.ProviderInitializationException;
import org.drools.util.ChainedProperties;
import org.drools.util.OSGiLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProviderLocator {
    private static final String CONFIG_FILE = "services.conf";
    private static final String ERR_FILE_READ = "Unable to read the Provider-Configuration File for {0}.";
    private static final String ERR_EXTENDS = "Provider {0} does not extend {2}.";
    private static final String ERR_IMPLEMENTS = "Provider {0} does not implement {2}.";
    private static final String ERR_NOT_ACCESSIBLE = "Provider {0} is not accessible.";
    private static final String ERR_NOT_CONCRETE = "Provider {0} cannot be instantiated.";
    private static final String ERR_NOT_FOUND = "Provider for {0} could not be found.";

    protected static final <T> T newProviderFor(Class<T> serviceClass) throws ProviderInitializationException {
        return ProviderLocator.newProviderFor(serviceClass, null);
    }

    protected static final <T> T newProviderFor(Class<T> serviceClass, ClassLoader classLoader) throws ProviderInitializationException {
        InputStream providerConfigFile;
        Class<?> providerClass = OSGiLocator.locate(serviceClass.getName());
        if (providerClass != null) {
            return ProviderLocator.newInstance(serviceClass, providerClass);
        }
        ChainedProperties props = new ChainedProperties(classLoader, CONFIG_FILE);
        String providerName = props.getProperty(serviceClass.getName(), null);
        if (providerName != null) {
            return ProviderLocator.newInstance(serviceClass, providerName, classLoader);
        }
        String serviceId = "META-INF/services/".concat(serviceClass.getName());
        InputStream inputStream = providerConfigFile = classLoader != null ? classLoader.getResourceAsStream(serviceId) : ClassLoader.getSystemResourceAsStream(serviceId);
        if (providerConfigFile != null) {
            try {
                List<String> results = ProviderLocator.readProvidersFrom(providerConfigFile);
                if (!results.isEmpty()) {
                    T t = ProviderLocator.newInstance(serviceClass, results.get(0), classLoader);
                    return t;
                }
            }
            catch (IOException e) {
                String msg = MessageFormat.format(ERR_FILE_READ, serviceClass.getName());
                throw new ProviderInitializationException(msg, e);
            }
            finally {
                try {
                    providerConfigFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String msg = MessageFormat.format(ERR_NOT_FOUND, serviceClass.getName());
        throw new ProviderInitializationException(msg);
    }

    protected static final List<String> readProvidersFrom(InputStream stream) throws IOException {
        LinkedHashSet<String> results = new LinkedHashSet<String>();
        if (stream != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                int pos = line.indexOf(35);
                if (pos >= 0) {
                    line = line.substring(0, pos);
                }
                if ((line = line.trim()).length() == 0) continue;
                results.add(line);
            }
        }
        return new ArrayList<String>(results);
    }

    private static <T> T newInstance(Class<T> serviceClass, String providerName, ClassLoader classLoader) throws ProviderInitializationException {
        try {
            Class<?> providerClass = classLoader == null ? Class.forName(providerName) : classLoader.loadClass(providerName);
            return ProviderLocator.newInstance(serviceClass, providerClass);
        }
        catch (ClassNotFoundException e) {
            String msg = MessageFormat.format(ERR_NOT_FOUND, serviceClass.getName());
            throw new ProviderInitializationException(msg, e);
        }
    }

    private static <T> T newInstance(Class<T> serviceClass, Class<?> providerClass) throws ProviderInitializationException {
        try {
            Object provider = providerClass.newInstance();
            return serviceClass.cast(provider);
        }
        catch (InstantiationException e) {
            String msg = MessageFormat.format(ERR_NOT_CONCRETE, providerClass.getName());
            throw new ProviderInitializationException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = MessageFormat.format(ERR_NOT_ACCESSIBLE, providerClass.getName());
            throw new ProviderInitializationException(msg, e);
        }
        catch (ClassCastException e) {
            String pattern = serviceClass.isInterface() ? ERR_IMPLEMENTS : ERR_EXTENDS;
            String msg = MessageFormat.format(pattern, providerClass.getName(), serviceClass.getName());
            throw new ProviderInitializationException(msg, e);
        }
    }
}

